/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.LanguageHandler;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.creativetab.ModCreativeTabs;
import com.ldtteam.structurize.items.AbstractItemStructurize;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ItemScanTool
extends AbstractItemStructurize {
    public ItemScanTool() {
        super("scepterSteel");
        super.func_77637_a(ModCreativeTabs.STRUCTURIZE);
        this.func_77625_d(1);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return Float.MAX_VALUE;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @NotNull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        BlockPos pos1 = BlockPosUtil.readFromNBT(compound, "pos1");
        BlockPos pos2 = BlockPosUtil.readFromNBT(compound, "pos2");
        if (!worldIn.field_72995_K) {
            if (playerIn.func_70093_af()) {
                ItemScanTool.saveStructure(worldIn, pos1, pos2, playerIn, null);
            }
        } else if (!playerIn.func_70093_af()) {
            WindowScan window = new WindowScan(pos1, pos2);
            window.open();
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound compound;
        BlockPos pos1;
        BlockPos pos2;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((pos2 = pos).func_177951_i((Vec3i)(pos1 = BlockPosUtil.readFromNBT(compound = stack.func_77978_p(), "pos1"))) > 0.0) {
            BlockPosUtil.writeToNBT(compound, "pos2", pos2);
            if (worldIn.field_72995_K) {
                LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.point2", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            stack.func_77982_d(compound);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void saveStructure(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull EntityPlayer player, String name) {
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vec3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > 100000) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.max.schematic.reached", 100000);
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.scepterSteel.scanFormat", "", currentMillisString) : name;
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), name, new String[0]);
        Structurize.getNetwork().sendTo((IMessage)new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), fileName), (EntityPlayerMP)player);
    }

    public static boolean saveStructureOnServer(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, String name) {
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vec3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > 100000) {
            Log.getLogger().warn("Saving too large schematic for:" + name);
        }
        String prefix = "cache";
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.scepterSteel.scanFormat", new Object[0]) : name;
        StructureName structureName = new StructureName("cache", "backup", fileName);
        List<File> folder = StructureLoadingUtils.getCachedSchematicsFolders();
        if (folder == null || folder.isEmpty()) {
            Log.getLogger().warn("Unable to save schematic in cache since no folder was found.");
            return false;
        }
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), name, new String[0]);
        File file = new File(folder.get(0), structureName.toString() + ".blueprint");
        Utils.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)BlueprintUtil.writeBlueprintToNBT(bp), (OutputStream)outputstream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

